--
-- file prepared: 15 May 2024 23:19:20.113, using fd633c
--
--Ammunition M39
local m39_smoke_scale   = 1.0;
local m39_smoke_opacity = 0.3;

--
-- M4 round 1 (37.0)
--
declare_weapon({category = CAT_SHELLS,name = "M4_37_HEI",
  user_name		= _("M4_37_HEI_A"),
  model_name     = "tracer_bullet_yellow",
  v0    		 = 990.0,
  Dv0   		 = 0.0060,
  Da0     		 = 0.0022,
  Da1     		 = 0.0,
  mass      	 = 0.100,
  round_mass 	 = 0.260+0.058,		-- round + link
  cartridge_mass = 0.058,			-- links are collected
  explosive      = 0.110,
  life_time      = 31.0,
  caliber        = 37.0,
  s              = 0.0,
  j              = 0.0,
  l              = 0.0,
  charTime       = 0,
  cx       		 = {0.5,1.27,0.70,0.200,2.30},
  k1       		 = 2.0e-08,
  tracer_on      = 0.01,
  tracer_off     = -100,
  scale_tracer   = 0,
  scale_smoke    = m39_smoke_scale, 
  smoke_opacity  = m39_smoke_opacity,
  cartridge		 = 0,

})

--
-- M4 round 2 (37.0)
--
declare_weapon({category = CAT_SHELLS,name =   "M4_37_HEI_T",
  user_name		= _("M4_37_HEI_TA"),
  model_name     = "tracer_bullet_yellow",
  v0    		 = 990.0,
  Dv0   		 = 0.0060,
  Da0     		 = 0.0022,
  Da1     		 = 0.0,
  mass      	 = 0.100,
  round_mass 	 = 0.260+0.058,		-- round + link
  cartridge_mass = 0.058,			-- links are collected
  explosive      = 0.110,
  life_time      = 31.0,
  caliber        = 37.0,
  s              = 0.0,
  j              = 0.0,
  l              = 0.0,
  charTime       = 0,
  cx       		 = {0.5,1.27,0.70,0.200,2.30},
  k1       		 = 2.0e-08,
  tracer_on      = 0.07,
  tracer_off     = 3,
  scale_tracer   = 1,
  scale_smoke    = m39_smoke_scale, 
  smoke_opacity  = m39_smoke_opacity,
  cartridge		 = 0,

})

--
-- M4 round 3 (37.0)
--
declare_weapon({category = CAT_SHELLS,name =   "M4_37_API",
  user_name		= _("M4_37_API"),
  model_name     = "tracer_bullet_yellow",
  v0    		 = 990.0,
  Dv0   		 = 0.0060,
  Da0     		 = 0.0022,
  Da1     		 = 0.0,
  mass      	 = 0.100,
  round_mass 	 = 0.260+0.058,		-- round + link
  cartridge_mass = 0.058,			-- links are collected
  explosive      = 0.000,
  AP_cap_caliber = 20.0,
  life_time      = 31.0,
  caliber        = 37.0,
  s              = 0.0,
  j              = 0.0,
  l              = 0.0,
  charTime       = 0,
  cx       		 = {0.5,1.27,0.70,0.200,2.30},
  k1       		 = 2.0e-08,
  tracer_on      = 0.01,
  tracer_off     = -100,
  scale_tracer   = 0,
  scale_smoke    = m39_smoke_scale, 
  smoke_opacity  = m39_smoke_opacity,
  cartridge		 = 0,

})

--
-- M4 cannon
--
function M_4(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "M_4"
	tbl.supply 	 =
	{
		shells = {"M4_37_HEI","M4_37_HEI_T","M4_37_API"},

		mixes  = {{1,1,3,1,2}},
		count  = 250,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 25,
		rates 			 = {1500},		--M39
		recoil_coeff 	 = 1,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {-0.4, -1.2, 0.18}
	tbl.ejector_dir 			= {0,-1,0}
	tbl.supply_position  		= tbl.supply_position   or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1500
	tbl.drop_cartridge 			= 0
	tbl.muzzle_pos				= tbl.muzzle_pos 		 or  {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 		 or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}}
	end
	return declare_weapon(tbl)
end



----------------------------------------------------------------------------------------------------------------------


--
-- M2 round 1 (12.7)
--
declare_weapon({category = CAT_SHELLS,name = "M2_12_7_T",
  user_name		= _("M2_12_7_T"),
  model_name    = "tracer_bullet_red",

  v0    = 930.0,
  Dv0   = 0.0060,
  Da0     = 0.0005,
  Da1     = 0.0,
  mass      = 0.046,
  round_mass = 0.145,
  explosive     = 0.0000,
  life_time     = 7,
  caliber     = 12.7,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {1.0,0.62,0.65,0.175,1.80},
  k1        = 1.5e-08,
  tracer_off    = 4,
  scale_tracer  = 1,

  name = "12.7",
  
  cartridge = 0,

  
})

--
-- M2 round 2 (12.7)
--
declare_weapon({category = CAT_SHELLS, name = "Utes_12_7x108",
  user_name		= _("Utes_12_7x108"),
  model_name    = "tracer_bullet_green",
 
  v0    = 840.0,
  Dv0   = 0.0082,
  Da0     = 0.00085,
  Da1     = 0.0,
  mass      = 0.047,
  round_mass = 0.130,
  explosive     = 0.0000,
  life_time     = 7,
  caliber     = 12.7,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {0.5,0.61,0.8,0.27,1.9},
  k1        = 1.2e-08,
  tracer_off    = 4,
  scale_tracer  = 1,

  name = "12.7",
  
  cartridge = 0,

})

--
-- M2 cannon
--
function M_2(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "M_2"
	tbl.supply 	 =
	{
		shells = {"M2_12_7_T", "Utes_12_7x108" },
		mixes  = {{1,1,2,1,2}},
		count  = 1800,		--unsure of actual count, p40 has 6xcannon, so assuming 300 rounds each  --1800 rounds for f80	  -- Ho 103 (1000)	
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 25,
		rates 			 = {1200},		--p40 (1200)  --f80  (1200)  -- Ho 103 (983)
		recoil_coeff 	 = 0.2*1.3,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {-0.4, -1.2, 0.18}
	tbl.ejector_dir 			= {0,-1,0}
	tbl.supply_position  		= tbl.supply_position   or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1500
	tbl.drop_cartridge 			= 0
	tbl.muzzle_pos				= tbl.muzzle_pos 		 or  {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 		 or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}}
	end
	return declare_weapon(tbl)
end


--
--	note: the above is modelled after the example for the M2 and M_39 cannons as found in Scripts\Database\Weapons\aircraft_gun_mounts.lua, and
--  the examples for M39_20_HEI, M39_20_HEI_T, and M39_20_API rounds, and the M2_12_7_T, and Utes_12_7x108 rounds as found in Scripts\Database\Weapons\shell_table.lua
--




